<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddRegistraionBonusPermission extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => "Registration Bonus", 'route' => 'registraion_bonus', 'type' => 1, 'parent_route' => null, 'module' => 'RegistrationBonus'],
            ['name' => 'Bonus History', 'route' => 'registraion_bonus.history', 'type' => 2, 'parent_route' => 'registraion_bonus', 'module' => 'RegistrationBonus'],
            ['name' => 'Show', 'route' => 'registraion_bonus.history.show', 'type' => 3, 'parent_route' => 'registraion_bonus.history', 'module' => 'RegistrationBonus'],

            ['name' => 'Settings', 'route' => 'registration_bonus.setting', 'type' => 2, 'parent_route' => 'registraion_bonus', 'module' => 'RegistrationBonus'],
            ['name' => 'Update', 'route' => 'registration_bonus.setting.update', 'type' => 3, 'parent_route' => 'registration_bonus.setting', 'module' => 'RegistrationBonus'],
        ];

        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }

    public function down()
    {
        $routes = [
            "registraion_bonus",
            "registraion_bonus.history",
            "registraion_bonus.history.show",
            "registration_bonus.setting",
            "registration_bonus.setting.update"
        ];

        foreach ($routes as $route) {
            Permission::where('route', $route)->delete();
        }
    }
}
