<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\SystemSetting\Entities\EmailTemplate;

class InstallmentEmailTemplatesTable extends Migration
{
    public function up()
    {
        $template = EmailTemplate::where('act', 'Installment_Request_Reject')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'Installment_Request_Reject';
        }
        $shortCode = '{"name":"Student Name","course":"Course Name","plan":"Installment Plan Name","course_link":"Course Link","footer":"Email Footer"}';

        $subject = 'Installment Request Rejected';


        $br = "<br/>";
        $body = " Dear {{name}}, " . $br . $br . " Your Purchase Request for {{course}} course with {{plan}} plan has been rejected. " . $br . $br . " {{course_link}} " . $br . $br . " {{footer}} " . $br . $br . " Thanks";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;

        $template->email_body = htmlPart($subject, $body);
        $template->save();

        DB::table('role_email_templates')
            ->where('template_act', 'Installment_Request_Reject')
            ->where('role_id', 3,)
            ->updateOrInsert([
                'template_act' => 'Installment_Request_Reject',
                'role_id' => 3,
                'status' => 1,
            ]);

        DB::table('role_email_templates')
            ->where('template_act', 'Installment_Request_Reject')
            ->where('role_id', 2,)
            ->updateOrInsert([
                'template_act' => 'Installment_Request_Reject',
                'role_id' => 2,
                'status' => 1,
            ]);

        $template = EmailTemplate::where('act', 'Installment_Request_Approved')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'Installment_Request_Approved';
        }
        $shortCode = '{"name":"Student Name","course":"Course Name","plan":"Installment Plan Name","course_link":"Course Link","footer":"Email Footer"}';

        $subject = 'Installment Request Approved';


        $br = "<br/>";
        $body = " Dear {{name}}, " . $br . $br . " Your Purchase Request for {{course}} course with {{plan}} plan has been Approved. " . $br . $br . " {{course_link}} " . $br . $br . " {{footer}} " . $br . $br . " Thanks";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;

        $template->email_body = htmlPart($subject, $body);
        $template->save();

        DB::table('role_email_templates')
            ->where('template_act', 'Installment_Request_Approved')
            ->where('role_id', 3,)
            ->updateOrInsert([
                'template_act' => 'Installment_Request_Approved',
                'role_id' => 3,
                'status' => 1,
            ]);

        DB::table('role_email_templates')
            ->where('template_act', 'Installment_Request_Approved')
            ->where('role_id', 2,)
            ->updateOrInsert([
                'template_act' => 'Installment_Request_Approved',
                'role_id' => 2,
                'status' => 1,
            ]);


        $template = EmailTemplate::where('act', 'Installment_Reminder')->first();
        if (!$template) {
            $template = new EmailTemplate();
            $template->act = 'Installment_Reminder';
        }
        $shortCode = '{"name":"Student Name","course":"Course Name","plan":"Installment Plan Name","due_date":"Due Date","course_link":"Course Link","footer":"Email Footer"}';

        $subject = 'Installment Reminder';


        $br = "<br/>";
        $body = " Dear {{name}}, " . $br . $br . " Your Installment for {{course}} course with {{plan}} plan is close to due date . " . $br . $br . " {{due_date}}. Please complete your payment. " . $br . $br . " {{course_link}} " . $br . $br . " {{footer}} " . $br . $br . " Thanks";
        $template->name = $subject;
        $template->subj = $subject;
        $template->shortcodes = $shortCode;
        $template->status = 1;

        $template->email_body = htmlPart($subject, $body);
        $template->save();

        DB::table('role_email_templates')
            ->where('template_act', 'Installment_Reminder')
            ->where('role_id', 3,)
            ->updateOrInsert([
                'template_act' => 'Installment_Reminder',
                'role_id' => 3,
                'status' => 1,
            ]);

        DB::table('role_email_templates')
            ->where('template_act', 'Installment_Reminder')
            ->where('role_id', 2,)
            ->updateOrInsert([
                'template_act' => 'Installment_Reminder',
                'role_id' => 2,
                'status' => 1,
            ]);
    }


    public function down()
    {

    }
}
