<?php

namespace Modules\Installment\Console;

use App\Jobs\SendNotification;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Modules\Setting\Model\GeneralSetting;
use Modules\Installment\Entities\InstallmentPlan;
use Modules\Installment\Entities\InstallmentPurchaseRequest;

class InstallmentDue extends Command
{

    protected $name = 'installment:due-check';


    protected $description = 'Send installment due notification to user';


    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $installment_purchase_requests = InstallmentPurchaseRequest::whereNotIn('payment_status', ['incomplete'])
            ->with('user', 'installmentPayments')
            ->get();

        $due_courses = [];

        foreach ($installment_purchase_requests as $key => $purchase) {
            $user = $purchase->user;
            $settings_fields = ['installment_reminder_days_before', 'installment_reminder_days_after_due', 'disable_installment'];
            $settings = GeneralSetting::where('lms_id', $user->lms_id)->select('key', 'value', 'lms_id')->whereIn('key', $settings_fields)->get();

            $installment_reminder_days_before = $settings->where('key', 'installment_reminder_days_before')->first()->value;
            $installment_reminder_days_after_due = $settings->where('key', 'installment_reminder_days_after_due')->first()->value;
            $disable_installment = $settings->where('key', 'disable_installment')->first()->value;

            $user_due_courses[$user->id] = [];
            foreach ($purchase->installmentPayments->where('status', '!=', 'paid') as $key => $payment_record) {
                if ($installment_reminder_days_before != null) {
                    $due_date = Carbon::parse($payment_record->due_date);
                    $due_date2 = Carbon::parse($payment_record->due_date);
                    $reminder_date_before_due = $due_date->subDays((int)$installment_reminder_days_before)->toDateString();
                    $reminder_date_after_due = $due_date2->addDays((int)$installment_reminder_days_after_due)->toDateString();

                    if ($reminder_date_after_due == Carbon::now()->toDateString()) {
                        $payment_record->is_overdue = 1;
                        $payment_record->save();
                    }

                    if ($reminder_date_before_due == Carbon::now()->toDateString() || $reminder_date_after_due == Carbon::now()->toDateString()) {
                        SendNotification::dispatch('Installment_Reminder', $purchase->user, [
                            'name' => $purchase->user->name,
                            'course' => $purchase->topic->title,
                            'plan' => $purchase->plan->title,
                            'due_date' => Carbon::parse($payment_record->due_date)->format('jS M, Y'),
                            'course_link' => courseDetailsUrl(@$purchase->topic->id, @$purchase->topic->type, @$purchase->topic->slug),
                        ],[]);
                    }

                }
                if ($reminder_date_after_due < Carbon::now()->toDateString()) {

                    array_push($user_due_courses[$user->id], $purchase->topic_id);
                }
            }

            $user->installment_eligibility = $user_due_courses[$user->id] == [] ? 1 : 0;
            $user->installment_due_course = $user_due_courses[$user->id] == [] ? null : implode(',', $user_due_courses[$user->id]);
            $user->save();
        }


        $plans = InstallmentPlan::where('status', 1)->get();
        foreach ($plans as $key => $plan) {
            $plan_capacity = $plan->planCapacity();
            if ($plan_capacity['exist'] == 0) {
                $plan->status = 0;
                $plan->save();
            }
        }
    }

}
