@extends('appointment::layouts.master')
@php
    $table_name = 'schedules';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@push('styles')
    <style>
        .yearColor {
            font-weight: 700;
            color: #bb37de;
        }

    </style>
@endpush
@section('mainContent')
    @php
        $week_number = isset($week_number) ? $week_number : $this_week;
        $start_date = date('Y-m-d', strtotime($weekDates[0]));
        $end_date = date('Y-m-d', strtotime($weekDates[6]));
    @endphp
    {!! generateBreadcrumb() !!}

    <input type="hidden" name="user_id" id="user_id" value="{{ $user_id }}">
    <input type="hidden" name="next_date" id="next_date" value="{{ $end_date }}">
    <input type="hidden" name="pre_date" id="pre_date" value="{{ $start_date }}">
    <input type="hidden" name="slot" id="slot_id">
    <input type="hidden" name="edit_schedule_id" id="edit_schedule_id" value="">
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center mt-0">
                @if(auth()->user()->role_id == 1)
                    <div class="col-lg-12">
                        <div class="white_box mb_30">
                            <form action="{{ route('appointment.schedule.search.instructor-schedule') }}" method="POST">
                                @csrf

                                <div class="row align-items-end">

                                    <div class="col-lg-6">

                                        <label class="primary_input_label"
                                               for="instructor">{{ __('courses.Instructor') }}</label>
                                        <select class="primary_select" name="instructor" id="instructor" required>

                                            <option value="">{{__('common.Select One')}}</option>
                                            @foreach ($instructors as $data)
                                                <option value="{{ $data->id }}"
                                                    {{ isset($instructor) ? ($instructor->id == $data->id ? 'selected' : '') : '' }}>
                                                    {{ @$data->name }} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                    <div class="col-6">
                                        <div class="search_course_btn text-center">
                                            <button type="submit"
                                                    class="primary-btn radius_30px   fix-gr-bg">{{ __('courses.Filter') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                @endif
                <div class="col-12">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-12">
                                <div class="common_table_header mb_20">
                                    <div class="main-title">

                                        <h3 class="text-center ">

                                            <a href="#" id="preWeek"> <i class="fa fa-angle-left"></i> </a>
                                            {{ __('appointment.Week') }} <span id="weeknumber">{{ $week_number }}</span>
                                            |
                                            <span class="yearColor">{{ date('Y', strtotime($weekDates[0])) }}</span>

                                            <a href="#" id="nextWeek" class="fix-gr-bg"> <i
                                                    class="fa fa-angle-right "></i> </a>

                                        </h3>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-12 white-box">
                                <div class="schedule_loader d-none" id="pre_loader">
                                    <div class="row position-relative text-center">
                                        <div class="course-preloader ">
                                            <i class="fa fa-spinner fa-spin fa-2x fa-fw"></i>
                                        </div>
                                    </div>
                                </div>

                                <div class="schedule" id="schedule">
                                    <div class="table-responsive">

                                        <table class="display school-table school-table-style p-0 shadow-none"
                                               cellspacing="0"
                                               width="100%">
                                            <thead class="text-nowrap">
                                            <tr>
                                                <th class="ps-2">{{ __('appointment.Time Slot') }}</th>
                                                @foreach ($periods as $key => $date)
                                                    <th>{{ $date->translatedFormat('d-M-y') }} <br>

                                                        {{ $date->translatedFormat('l') }}
                                                    </th>
                                                @endforeach
                                            </tr>
                                            </thead>

                                            <tbody>
                                            @foreach ($timeSlots as $slot)
                                                <tr>
                                                    <td class="ps-2">{{ date('h:i A', strtotime(@$slot->start_time)) }}
                                                        -
                                                        {{ date('h:i A', strtotime(@$slot->end_time)) }}</td>
                                                    @foreach ($periods as $key => $date)
                                                        <td>
                                                            @php
                                                                $teachingInfo = Modules\Appointment\Entities\Schedule::teachingInfo($slot->id, $date->format('Y-m-d'), $user_id);

                                                            @endphp
                                                            @if ($teachingInfo)
                                                                {{ $teachingInfo->category->name }} <br>
                                                                {{ $teachingInfo->sub_category ? '(' . $teachingInfo->subCategory->name . ')' : '' }}

                                                                <label class="switch_toggle">
                                                                    <input type="checkbox"
                                                                           class="schedule_status_enable_disable"
                                                                           @if (@$teachingInfo->status == 1) checked
                                                                           @endif
                                                                           value="{{ @$teachingInfo->id }}">
                                                                    <i class="slider round"></i>
                                                                </label>
                                                                @if(count($teachingInfo->activeBooked) > 0)
                                                                    <p>{{ __('appointment.Total Booked') }} :
                                                                        <a href="{{ route('appointment.booking.user',['date'=>$date->format('Y-m-d'), 'time_slot' => $slot->id, 'instructor_id'=>$user_id]) }}"
                                                                           target="_blank">
                                                                            <strong>({{ count($teachingInfo->activeBooked) }}
                                                                                )</strong></a>
                                                                    </p>
                                                                @endif


                                                                <div class="d-flex">
                                                                    @if (permissionCheck('appointment.schedule.edit'))
                                                                        <a data-bs-toggle="modal"
                                                                           id="edit_schedule_modal_btn"
                                                                           data-bs-target="#edit_schedule_modal_{{ $teachingInfo->id }}"
                                                                           href="#"
                                                                           data-schedule_id="{{ $teachingInfo->id }}"
                                                                           class="primary-btn small icon-only edit_schedule_modal"
                                                                           data-modal-size="modal-md"
                                                                           title="{{ __('appointment.Update Schedule') }}">
                                                                            <span class="ti-pencil" id=""></span>
                                                                        </a>
                                                                    @endif
                                                                    @if (permissionCheck('appointment.schedule.destroy'))
                                                                        <a onclick="confirm_modal('{{ route('appointment.schedule.destroy', @$teachingInfo->id) }}');"
                                                                           class="primary-btn small icon-only"
                                                                           data-modal-size="modal-md"
                                                                           title="">
                                                                            <span class="ti-trash" id=""></span>
                                                                        </a>
                                                                    @endif
                                                                </div>
                                                                @includeIf('appointment::schedule.inc._edit_schedule_modal')
                                                            @else
                                                                @if (permissionCheck('appointment.schedule.store'))
                                                                    <a data-bs-toggle="modal" id="add_schedule_btn"
                                                                       data-bs-target="#add_schedule"
                                                                       href="#"
                                                                       class="primary-btn small icon-only   add_schedule_btn"
                                                                       data-slot_id="{{ $slot->id }}"
                                                                       data-start_date="{{ $date->format('m/d/Y') }}"
                                                                       data-modal-size="modal-md"
                                                                       title="{{ __('appointment.Add New Schedule') }}">
                                                                        <span class="ti-plus" id=""></span>
                                                                    </a>
                                                                @endif
                                                            @endif

                                                        </td>
                                                    @endforeach
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @include('appointment::schedule.inc._add_schedule_modal')

    @includeIf('backend.partials.delete_modal')
@endsection
@push('scripts')
    @if (isset($errors) && count($errors) > 0)
        <script>
            (function ($) {
                "use strict";
                $(document).ready(function () {
                    $('#add_schedule').modal('show');
                })
            })(jQuery);

        </script>
    @endif
    <script>
        (function ($) {
            "use strict";
            $(document).on('click', '#preWeek', function (e) {
                e.preventDefault();
                $('#pre_loader').removeClass('d-none');
                let next_date = '';
                let pre_date = $("#pre_date").val();
                let last_date_of_week = moment(pre_date).subtract(1, 'd').format('YYYY-MM-DD');
                let first_date_of_week = moment(pre_date).subtract(7, 'd').format('YYYY-MM-DD');
                let weeknumber = moment(first_date_of_week, "YYYY-MM-DD").week();
                changeWeek(next_date, pre_date, first_date_of_week, last_date_of_week, weeknumber);
            })
            $(document).on('click', '#nextWeek', function (e) {
                e.preventDefault();
                $('#pre_loader').removeClass('d-none');
                let next_date = $("#next_date").val();
                let pre_date = '';
                let first_date_of_week = moment(next_date).add(1, 'd').format('YYYY-MM-DD');
                let last_date_of_week = moment(next_date).add(7, 'd').format('YYYY-MM-DD');
                let weeknumber = moment(first_date_of_week, "YYYY-MM-DD").week();
                let weekNumber = weeknumber - 1;
                changeWeek(next_date, pre_date, first_date_of_week, last_date_of_week, weeknumber);

            })

            function changeWeek(next_date, pre_date, first_date_of_week, last_date_of_week, weeknumber) {

                var url = $("#url").val();
                var user_id = $('#user_id').val();
                var formData = {
                    instructor: user_id,
                    next_date: next_date,
                    pre_date: pre_date,
                };

                $.ajax({
                    type: "get",
                    data: formData,
                    dataType: "html",
                    url: url + "/appointment/schedule/next-week/" + "next-week",

                    success: function (data) {
                        $('#schedule').html('');
                        $('#schedule').html(data);
                        $('#weeknumber').html(weeknumber);
                        $("#pre_date").val(first_date_of_week);
                        $("#next_date").val(last_date_of_week);
                        $('#pre_loader').addClass('d-none');

                    },

                    error: function (data) {

                    }

                });

            }

            $(document).on('click', '.add_schedule_btn', function () {
                let slot_id = $(this).data('slot_id');
                let start_date = $(this).data('start_date');
                $('#slot_id').val(slot_id);
                $('#start_date').val(start_date);
            })
            $(document).on('click', '.edit_schedule_modal', function () {
                let edit_schedule_id = $(this).data('schedule_id');
                $('#edit_schedule_id').val(edit_schedule_id);
                console.log(edit_schedule_id);
            })
            $(document).on('click', '.saveScheduleButton', function (e) {
                e.preventDefault();
                let url = $("#url").val();
                let slot_id = $('#slot_id').val();
                let user_id = $('#user_id').val();
                let start_date = $('#start_date').val();
                let end_date = $('#end_date').val();
                let category_id = $('#category_id').val();
                let sub_category_id = $('#sub_category_id').val();
                formData = {
                    slot: slot_id,
                    user: user_id,
                    start_date: start_date,
                    end_date: end_date,
                    category: category_id,
                    sub_category: sub_category_id,
                }
                // console.log(formData);
                if (start_date == '') {
                    setTimeout(function () {
                        toastr.error(
                            "Start Date Can't Be Empty",
                            "Error ", {
                                timeOut: 5000,
                            });
                    }, 500);

                    return;
                }
                if (category_id == '') {
                    setTimeout(function () {
                        toastr.error("Category Can't Be Empty", 'Error', {
                            timeOut: 5000,
                        });
                    }, 500);
                    $("#category_id").val('').niceSelect('update');
                    return;
                }
                if (end_date != '' && (start_date == end_date)) {
                    if (end_date < start_date) {
                        setTimeout(function () {
                            toastr.error("End Date will Be After Today or more", 'Error', {
                                timeOut: 5000,
                            });
                        }, 500);
                        return;
                    }
                }
                $('#saveScheduleButton').addClass('d-none');
                $('#savingButton').removeClass('d-none');

                let starting_date = $("#pre_date").val();
                let next_date = moment(starting_date).subtract(1, 'd').format('YYYY-MM-DD');
                let pre_date = '';
                let first_date_of_week = starting_date;
                let last_date_of_week = moment(next_date).add(7, 'd').format('YYYY-MM-DD');
                let weeknumber = moment(first_date_of_week, "YYYY-MM-DD").week();
                let weekNumber = weeknumber - 1;

                $.ajax({
                    type: 'POST',
                    data: formData,
                    dataType: 'JSON',
                    url: url + '/appointment/schedule/store',
                    success: function (data) {
                        setTimeout(function () {
                            toastr.success("Operation successful", 'Success', {
                                timeOut: 5000,
                            });
                        }, 500);
                        $('#saveScheduleButton').removeClass('d-none');

                        $("#category_id").val('').niceSelect('update');
                        $("#sub_category").val('').niceSelect('update');
                        $('#add_schedule').modal("hide");
                        $('#savingButton').addClass('d-none');
                        $('#pre_loader').removeClass('d-none');

                        changeWeek(next_date, pre_date, first_date_of_week, last_date_of_week, weeknumber);
                    },
                    error: function () {
                        setTimeout(function () {
                            toastr.error("Operation Failed", 'Error', {
                                timeOut: 5000,
                            });
                        }, 500);
                        $('#saveScheduleButton').removeClass('d-none');
                        $('#savingButton').addClass('d-none');
                    }
                })
            })
            $(document).on('click', '.updateScheduleButton', function (e) {
                e.preventDefault();

                var schedule_id = $('#edit_schedule_id').val();
                if ($('#move_slot_' + schedule_id).is(':checked')) {
                    var move_slot = 1;
                } else {
                    var move_slot = 0;
                }
                let url = $("#url").val();
                let user_id = $('#edit_user_id').val();
                let slot_id = $('#edit_time_slot_id_' + schedule_id).val();
                let start_date = $('#edit_date_' + schedule_id).val();
                let category_id = $('#edit_category_id_' + schedule_id).val();
                let sub_category_id = $('#edit_sub_category_id_' + schedule_id).val();
                formData = {
                    slot: slot_id,
                    user: user_id,
                    date: start_date,
                    move_slot: move_slot,
                    category: category_id,
                    start_date: start_date,
                    schedule_id: schedule_id,
                    sub_category: sub_category_id,
                }
                // console.log(formData);
                if (start_date == '') {
                    setTimeout(function () {
                        toastr.error(
                            "Start Date Can't Be Empty",
                            "Error ", {
                                timeOut: 5000,
                            });
                    }, 500);

                    return;
                }
                if (category_id == '') {
                    setTimeout(function () {
                        toastr.error("Category Can't Be Empty", 'Error', {
                            timeOut: 5000,
                        });
                    }, 500);
                    $("#category_id").val('').niceSelect('update');
                    return;
                }
                $('#updateScheduleButton_' + schedule_id).addClass('d-none');
                $('#updatingButton_' + schedule_id).removeClass('d-none');

                let starting_date = $("#pre_date").val();
                let next_date = moment(starting_date).subtract(1, 'd').format('YYYY-MM-DD');
                let pre_date = '';
                let first_date_of_week = starting_date;
                let last_date_of_week = moment(next_date).add(7, 'd').format('YYYY-MM-DD');
                let weeknumber = moment(first_date_of_week, "YYYY-MM-DD").week();
                let weekNumber = weeknumber - 1;
                $.ajax({
                    type: 'PUT',
                    data: formData,
                    dataType: 'JSON',
                    url: url + '/appointment/schedule/update/' + schedule_id,
                    success: function (data) {

                        $('#edit_schedule_modal_' + schedule_id).modal("hide");
                        if (data.successMsg) {
                            setTimeout(function () {
                                toastr.success(data.successMsg, 'Success', {
                                    timeOut: 5000,
                                });
                            }, 500);
                        }
                        if (data.waringMsg) {
                            setTimeout(function () {
                                toastr.warning(data.waringMsg, 'Warning', {
                                    timeOut: 5000,
                                });
                            }, 500);
                        }
                        $('#updateScheduleButton_' + schedule_id).removeClass('d-none');


                        $('#updatingButton_' + schedule_id).addClass('d-none');

                        $('#pre_loader').removeClass('d-none');

                        changeWeek(next_date, pre_date, first_date_of_week, last_date_of_week, weeknumber);

                    },
                    error: function () {
                        setTimeout(function () {
                            toastr.error("Operation Failed", 'Error', {
                                timeOut: 5000,
                            });
                        }, 500);
                        $('#saveScheduleButton').removeClass('d-none');
                        $('#savingButton').addClass('d-none');

                    }
                })
            })
        })(jQuery);


    </script>
@endpush
