@extends('appointment::layouts.master')
@php
    $table_name = 'book_trail_lessons';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@section('mainContent')
    <input type="hidden" id="row_count" value="1">
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="white_box mb_30">
                        <div class="white_box_tittle list_header main-title mb-0">
                            <h3>{{__('appointment.Filter Booked Trail Lesson History')}}</h3>

                        </div>
                        @php
                            $div = auth()->user()->role_id == 1 ? 'col-xl-3 col-md-3 col-lg-3' : 'col-xl-3 col-md-3 col-lg-3';
                            $divBtn = auth()->user()->role_id == 1 ? 'col-md-9 col-xl-9 mt-30' : 'col-md-12 col-xl-12 mt-30';
                        @endphp


                        <form method="POST" action="{{ route('appointment.booking.trail-lesson.search') }}">
                            @csrf
                            <div class="row">

                                <div class="{{ $div }}">

                                    <label class="primary_input_label"
                                           for="instructor">{{__('appointment.Time Slot')}}</label>
                                    <select class="primary_select" name="time_slot" id="instructor">
                                        <option data-display="{{__('common.Select')}} {{__('appointment.Time Slot')}}"
                                                value="">{{__('common.Select')}} {{__('appointment.Time Slot')}}</option>
                                        @foreach($timeSlots as $slot)
                                            <option
                                                value="{{$slot->id}}" {{isset($payload) ? ($payload['time_slot'] == $slot->id ? 'selected' : '') : ''}}>
                                                {{  date('h:i A', strtotime(@$slot->start_time))  }} -
                                                {{date('h:i A', strtotime(@$slot->end_time))  }} </option>
                                        @endforeach
                                    </select>

                                </div>
                                <div class="{{ $div }}">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="startDate">{{__('common.Select')}} {{__('common.Start Date')}}</label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('common.Date')}}"
                                                               class="primary_input_field primary-input date form-control"
                                                               id="startDate" type="text" name="start_date"
                                                               value="{{isset($payload)?!empty($payload['start_date'])?date('m/d/Y', strtotime($payload['start_date'])):'':''}}"
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar" id="start-date-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="{{ $div }}">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="admissionDate">{{__('common.Select')}} {{__('common.End Date')}}</label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('common.Date')}}"
                                                               class="primary_input_field primary-input date form-control"
                                                               id="admissionDate" type="text" name="end_date"
                                                               value="{{isset($payload)?!empty($payload['end_date'])?date('m/d/Y', strtotime($payload['end_date'])):'':''}}"
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar" id="admission-date-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="{{ $div }}">
                                    <label class="primary_input_label"
                                           for="status">{{__('common.Status')}}</label>
                                    <select class="primary_select" name="status">
                                        <option
                                            value="1" {{ isset($payload) ? ($payload['status'] == 1 ?'selected':'') :''}}>{{ __('appointment.Pending') }}</option>
                                        <option
                                            value="0" {{ isset($payload) ? ($payload['status'] == 0 ?'selected':'') :''}}>{{ __('appointment.Confirm Schedule') }}</option>
                                    </select>
                                </div>
                                @if(auth()->user()->role_id==1)
                                    <div class="{{ $div }}">

                                        <label class="primary_input_label"
                                               for="instructor">{{__('courses.Instructor')}}</label>
                                        <select class="primary_select" name="instructor" id="instructor">
                                            <option data-display="{{__('common.Select')}} {{__('courses.Instructor')}}"
                                                    value="">{{__('common.Select')}} {{__('courses.Instructor')}}</option>
                                            @foreach($instructors as $data)
                                                <option
                                                    value="{{$data->id}}" {{ isset($payload) ? ($payload['instructor'] == $data->id?'selected':'') :''}}>{{@$data->name}} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                @endif
                                <div class="col-12 mt-3">
                                    <div class="search_course_btn text-end">
                                        <button type="submit"
                                                class="primary-btn   w-fit   fix-gr-bg">
                                            <i class="ti-search"></i>
                                            {{__('common.Filter History')}}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                @isset($bookTrailLessons)

                    <div class="col-lg-12">
                        <div class="white-box">
                            <div class="box_header common_table_header">
                                <div class="main-title d-md-flex">
                                    <h3 class="mb-0"
                                        id="page_title">{{ __('appointment.Booked Trail Lesson List') }}</h3>
                                </div>
                            </div>
                            <div class="QA_section QA_section_heading_custom check_box_table">
                                <div class="QA_table ">
                                    <!-- table-responsive -->
                                    <div class="">
                                        <table id="lms_table" class="table Crm_table_active3">
                                            <thead>
                                            <tr>
                                                <th scope="col">{{ __('common.SL') }}</th>
                                                <th scope="col">{{ __('common.Student Name') }}</th>
                                                <th scope="col">{{ __('common.Date') }}</th>
                                                <th scope="col">{{ __('appointment.Time Slot') }}</th>

                                                <th scope="col">{{ __('common.Instructor') }}</th>
                                                <th scope="col">{{ __('appointment.Booked Time') }}</th>
                                                <th scope="col">{{ __('appointment.Share Link') }}</th>
                                                <th scope="col">{{ __('common.Action') }}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach ($bookTrailLessons as $key => $booking)
                                                <tr>
                                                    <td class="m-2">{{ $loop->iteration }}</td>
                                                    <td>{{ $booking->userInfo->name }}</td>
                                                    <td>{{ showDate($booking->schedule->schedule_date) }}</td>
                                                    <td>
                                                        @if($booking->schedule->slotInfo->start_time)
                                                            {{ date('h:i A', strtotime($booking->schedule->slotInfo->start_time)) }}
                                                            -
                                                            {{ date('h:i A', strtotime($booking->schedule->slotInfo->end_time)) }}
                                                        @else
                                                            {{__('common.N/A')}}
                                                        @endif

                                                    </td>

                                                    <td>{{ $booking->instructorInfo->name }}</td>

                                                    <td>{{ showDate($booking->created_at) }}</td>
                                                    <td>
                                                        @if($booking->share_link)
                                                            <a href="{{ $booking->share_link }}"
                                                               target="_blank">{{ __('appointment.Link') }}</a>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <div class="dropdown CRM_dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle"
                                                                    type="button"
                                                                    id="dropdownMenu1{{ @$booking->id }}"
                                                                    data-bs-toggle="dropdown"
                                                                    aria-haspopup="true" aria-expanded="false">
                                                                {{ __('common.Select') }}
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-right"
                                                                 aria-labelledby="dropdownMenu1{{ @$booking->id }}">

                                                                @if (permissionCheck('appointment.booking.set-schedule'))
                                                                    <a class="dropdown-item bookingSchedule_btn"
                                                                       data-bs-toggle="modal" id="bookingSchedule_btn"
                                                                       data-instructor_id="{{ $booking->instructor_id }}"
                                                                       data-trail_id="{{ $booking->id }}"
                                                                       data-bs-target="#bookingSchedule">{{ __('appointment.Booking Schedule') }}</a>
                                                                @endif
                                                                @if (permissionCheck('appointment.booking.trail-lesson.delete'))
                                                                    <a onclick="confirm_modal('{{ route('appointment.booking.trail-lesson.delete', @$booking->id) }}');"
                                                                       class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                                @endif


                                                            </div>
                                                        </div>
                                                        <!-- shortby  -->
                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endisset
            </div>
        </div>
    </section>

    @include('appointment::booking._booking_schedule_modal')
    @include('appointment::booking._share_link_modal')
    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script>
        (function ($) {
            "use strict";
            $(document).on('click', '.bookingSchedule_btn', function () {
                let instructor_id = $(this).data('instructor_id');
                let trail_id = $(this).data('trail_id');
                $('#schedule_instructor').val(instructor_id).niceSelect('update');
                $('#user_id').val(instructor_id);
                $('#trail_id').val(trail_id);
                instructorSchedule(instructor_id);
            })

            function instructorSchedule(instructor_id) {
                var url = $("#url").val();
                var formData = {
                    instructor_id: instructor_id,
                };
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "appointment/schedule/ajax/user-schedule",
                    success: function (data) {
                        // console.log(data);
                        var a = "";
                        $.each(data, function (i, item) {
                            if (item.length) {
                                $("#scheduleDate").find("option").not(":first").remove();
                                $("#scheduleDateDiv ul").find("li").not(":first").remove();

                                $.each(item, function (i, schedule) {
                                    $("#scheduleDate").append(
                                        $("<option>", {
                                            value: schedule.id,
                                            text: schedule.schedule_date,
                                        })
                                    );

                                    $("#scheduleDateDiv ul").append(
                                        "<li data-value='" +
                                        schedule.id +
                                        "' class='option'>" +
                                        schedule.schedule_date +
                                        "</li>"
                                    );
                                });
                            } else {
                                $("#scheduleDateDiv .current").html("Select Sub Category");
                                $("#scheduleDate").find("option").not(":first").remove();
                                $("#scheduleDateDiv ul").find("li").not(":first").remove();
                            }
                        });
                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });
            }

            $(document).on('click', '.add_share_btn', function () {
                let schedule_id = $(this).data('schedule_id');
                let student_id = $(this).data('student_id');
                let booking_id = $(this).data('booking_id');
                let type = $(this).data('type');
                if (type == 'single') {
                    $("#single").prop("checked", true);
                } else {
                    $("#all").prop("checked", true);
                }
                let share_link = $(this).data('share_link');
                $('#schedule_id').val(schedule_id);
                $('#student_id').val(student_id);
                $('#booking_id').val(booking_id);
                $('#share_link').val(share_link);
            })


            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);

    </script>
@endpush
