<div class="modal fade admin-query" id="bookingSchedule">
    <div class="modal-dialog  modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ __('appointment.Set Schedule') }}</h4>
                <button type="button" class="close " data-bs-dismiss="modal">
                    <i class="ti-close "></i>
                </button>
            </div>

            <div class="modal-body">


                <form method="POST" action="{{ route('appointment.booking.set-schedule') }}"
                      enctype="multipart/form-data">
                    @csrf <input type="hidden" name="slot" id="slot_id" value="">
                    <input type="hidden" name="user" id="user_id" value="">
                    <input type="hidden" name="trail_id" id="trail_id" value="">

                    <div class="row">

                        @if (auth()->user()->role_id == 1)
                            <div class="col-xl-12 mt-3">
                                <label class="primary_input_label"
                                       for="schedule_instructor">{{ __('common.Instructor') }}</label>
                                <select class="primary_select schedule_instructor" name="schedule_instructor"
                                        {{ $errors->has('schedule_instructor') ? 'autofocus' : '' }} id="schedule_instructor">
                                    <option data-display="{{ __('appointment.Select Instructor') }} " value="">
                                        {{ __('appointment.Select Instructor') }} </option>
                                    @isset($instructors)
                                        @foreach ($instructors as $item)
                                            <option value="{{ $item->id }}">
                                                {{ $item->name }}
                                            </option>
                                        @endforeach
                                    @endisset
                                </select>
                            </div>
                        @else
                            <input type="hidden" name="instructor_id" id="schedule_instructor">
                        @endif

                        <div class="col-xl-12 mt-3" id="scheduleDateDiv">
                            <label class="primary_input_label"
                                   for="schedule_date">{{ __('appointment.Schedule Date') }}</label>
                            <select class="primary_select schedule_date" name="schedule_date"
                                    {{ $errors->has('time_slot') ? 'autofocus' : '' }} id="scheduleDate">
                                <option data-display="{{ __('common.Select') }} {{ __('appointment.Schedule Date') }} "
                                        value="">
                                    {{ __('common.Select') }} {{ __('appointment.Schedule Date') }} </option>
                            </select>
                        </div>


                        <div class="col-xl-12 mt-3" id="timeSlotDiv">
                            <label class="primary_input_label" for="time_slot">{{ __('appointment.Time Slot') }}</label>
                            <select class="primary_select time_slot" name="time_slot"
                                    {{ $errors->has('time_slot') ? 'autofocus' : '' }} id="timeSlot">
                                <option data-display="{{ __('common.Select') }} {{ __('appointment.Time Slot') }} "
                                        value="">
                                    {{ __('common.Select') }} {{ __('appointment.Time Slot') }} </option>
                            </select>
                        </div>

                    </div>
                    <div class="col-lg-12 text-center pt_15">
                        <div class="d-flex justify-content-center">
                            <button class="primary-btn semi_large2  fix-gr-bg " id="" type="submit"><i
                                    class="ti-check"></i> {{ __('common.Save') }}
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
    (function ($) {
        "use strict";
        $(document).ready(function () {

            $(document).on('change', '.schedule_instructor', function () {
                var instructor_id = $('#schedule_instructor').val();
                instructorSchedule(instructor_id);
            });

            function instructorSchedule(instructor_id) {
                var url = $("#url").val();
                var formData = {
                    instructor_id: instructor_id,
                };
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "appointment/schedule/ajax/user-schedule",
                    success: function (data) {
                        var a = "";
                        $.each(data, function (i, item) {
                            if (item.length) {
                                $("#scheduleDate").find("option").not(":first").remove();
                                $("#scheduleDateDiv ul").find("li").not(":first").remove();

                                $.each(item, function (i, schedule) {
                                    $("#scheduleDate").append(
                                        $("<option>", {
                                            value: schedule.id,
                                            text: schedule.schedule_date,
                                        })
                                    );

                                    $("#scheduleDateDiv ul").append(
                                        "<li data-value='" +
                                        schedule.id +
                                        "' class='option'>" +
                                        schedule.schedule_date +
                                        "</li>"
                                    );
                                });
                            } else {
                                $("#scheduleDateDiv .current").html("Select Sub Category");
                                $("#scheduleDate").find("option").not(":first").remove();
                                $("#scheduleDateDiv ul").find("li").not(":first").remove();
                            }
                        });
                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });
            }

            //
            $(document).on('change', '.schedule_date', function () {
                var url = $("#url").val();

                var schedule_date = $(this).val();
                var instructor_id = $('#schedule_instructor').val();
                console.log(url);

                var formData = {
                    instructor_id: instructor_id,
                    schedule_date: schedule_date,
                };

                console.log(formData);
                $.ajax({
                    type: "GET",
                    data: formData,
                    dataType: "json",
                    url: url + "/" + "appointment/schedule/ajax/time-slot",
                    success: function (data) {
                        // console.log(data);
                        var a = "";
                        // $.loading.onAjax({img:'loading.gif'});
                        $.each(data, function (i, item) {
                            if (item.length) {
                                $("#timeSlot").find("option").not(":first").remove();
                                $("#timeSlotDiv ul").find("li").not(":first").remove();

                                $.each(item, function (i, timeSlot) {
                                    $("#timeSlot").append(
                                        $("<option>", {
                                            value: timeSlot.id,
                                            text: timeSlot.startToEnd,
                                        })
                                    );

                                    $("#timeSlotDiv ul").append(
                                        "<li data-value='" +
                                        timeSlot.id +
                                        "' class='option'>" +
                                        timeSlot.startToEnd +
                                        "</li>"
                                    );
                                });
                            } else {
                                $("#timeSlotDiv .current").html("Select Time Slot *");
                                $("#timeSlot").find("option").not(":first").remove();
                                $("#timeSlotDiv ul").find("li").not(":first").remove();
                            }
                        });
                    },
                    error: function (data) {
                        console.log("Error:", data);
                    },
                });

            });
        });
    })(jQuery);

</script>
