<?php

namespace Modules\Appointment\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Modules\Appointment\Repositories\Interfaces\MyAppointmentRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\ScheduleRepositoryInterface;

class MyAppointmentController extends Controller
{
    public $scheduleRepository;
    public $myAppointmentRepository;
    public function __construct(
        MyAppointmentRepositoryInterface $myAppointmentRepository,
        ScheduleRepositoryInterface $scheduleRepository
    ) {
        $this->myAppointmentRepository = $myAppointmentRepository;
        $this->scheduleRepository = $scheduleRepository;
    }
    public function index(Request $request)
    {
        return view(theme('pages.appointment_myAppointment'), compact('request'));
    }
    public function change(Request $request)
    {
        $next_date = $request->next_date ?? null;
        $end_date = $request->end_date ?? null;
        $data = $this->scheduleRepository->datePeriods($next_date, $end_date);
        return view(theme('pages.appointment_myAppointment_calendar_body'), compact('request'))->with($data);
    }

    public function create()
    {
        return view('appointment::create');
    }

    public function storeWishlist($instructor_slug)
    {
        if (!auth()->check()) {
            Toastr::warning(trans('common.Please Login'), trans('common.Warning'));
            return redirect()->back();
        }
        $this->myAppointmentRepository->storeWishList($instructor_slug);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));
        return redirect()->back();
    }
    public function myWishList(Request $request)
    {
        $data = $this->myAppointmentRepository->wishlist();
        $data['request'] = $request;
        return view(theme('pages.appointment_my_wishlist'), $data);
    }

    public function show($id)
    {
        return view('appointment::show');
    }

    public function edit($id)
    {
        return view('appointment::edit');
    }


}
