(function ($) {
    "use strict";
    let _token = $('meta[name=_token]').attr('content');
    if (typeof _token == 'undefined') {
        _token = $('#csrf_token').val();
    }
    $(document).ready(function () {
        $(document).on('input', '#url', function (event) {
            let ref;
            let url = $(this).val();
            let userName = $('#user_name').val();
            ref = '?ref=' + userName;
            let affiliateUrl = url + ref;
            $('#affiliate_link').val(affiliateUrl);


        });

        $(document).on('click', '#withdraw_request_btn', function (event) {
            let minimumWithdrawAmount = parseFloat($('#minimum_withdraw_amount').val());
            let userBalance = parseFloat($('#user_balance').val());
            if (userBalance < minimumWithdrawAmount) {
                toastr.info(window.jsLang('data_minimum_payout') + ' ' + minimumWithdrawAmount + '.  ' + window.jsLang('data_your_balance') + ' ' + userBalance)
            } else {
                $('#withdraw_request_modal').modal('show');
            }
        });

        $(document).on('keyup', '#withdraw_amount', function () {
            let withdrawAmount = parseFloat($(this).val());
            let userBalance = parseFloat($('#user_balance').val());
            let minimumWithdrawAmount = parseFloat($('#minimum_withdraw_amount').val());
            if (withdrawAmount > userBalance) {
                $('#withdraw_amount_msg').html('Insufficient Balance');
                $('#withdraw_submit_btn').prop('disabled', true);
                $(this).css({
                    'border': '1px solid red'
                });
                $(this).focus();
            } else if (withdrawAmount < minimumWithdrawAmount) {
                $('#withdraw_amount_msg').html("You Can't Payout Less Then Minimum Payout " + minimumWithdrawAmount);
                $('#withdraw_submit_btn').prop('disabled', true);
                $(this).css({
                    'border': '1px solid red'
                });
                $(this).focus();
            } else {
                $('#withdraw_amount_msg').html('');
                $('#withdraw_submit_btn').prop('disabled', false);
                $(this).css({
                    'border': "1px solid #eceef4"
                });
                $(this).focusout();
            }
        });

        $(document).on('submit', '#create_withdraw_request', function (event) {
            event.preventDefault();
            let formElement = $(this).serializeArray()
            let formData = new FormData();
            formElement.forEach(element => {
                formData.append(element.name, element.value);
            });
            formData.append('_token', _token);
            resetValidationError();
            $.ajax({
                url: $('#withdraw_request_store_url').val(),
                type: "POST",
                cache: false,
                contentType: false,
                processData: false,
                data: formData,
                success: function (response) {
                    create_form_reset();
                    $('#withdraw_request_modal').modal('hide');
                    window.location.reload();
                    toastr.success('data_withdraw_request_submitted', window.jsLang('data_success'));
                },
                error: function (response) {
                    showValidationErrors('#create_withdraw_request', response.responseJSON.errors);
                }
            });
        });


        //tab active
        $('a[data-bs-toggle="tab"]').on('show.bs.tab', function (e) {
            localStorage.setItem('activeAffiliateTab', $(e.target).attr('href'));
        });
        var activeTab = localStorage.getItem('activeAffiliateTab');

        if (activeTab) {
            $('a[href="' + activeTab + '"]').tab('show');
        }

        //end tab active


        function create_form_reset() {
            $('#create_withdraw_request')[0].reset();
            $(".primary_select").niceSelect('update');
        }

        function showValidationErrors(formType, errors) {
            $(formType + ' #error_withdraw_amount').text(errors.withdraw_amount);
            $(formType + ' #error_payment_type').text(errors.payment_type);
        }

        function resetValidationError() {
            $('#error_withdraw_amount').html('');
            $('#error_payment_type').html('');
        }

        $(document).on('click', '#create_affiliate_link_modal_btn', function (event) {
            $('#create_affiliate_link_modal').modal('show');
        });

        // open paypal modal

        $(document).on('click', '#affiliate_add_paypal_modal_btn', function (event) {
            $('#affiliate_add_paypal_modal').modal('show');
        });

        $(document).on('click', '.affiliate_buttons .copy_link', function (event) {
            const link = $(this).data('link');
            copyTextToClipboard(link,this)
        });


    });

    $(document).on('click', '.copyRefCode', function (event) {
        const link = $(this).data('link');
        copyTextToClipboard(link,this)
    })

    function copyTextToClipboard(link,element) {
        const tempInput = $('<input>');

        $(element).parent().append(tempInput);
        tempInput.val(link).select();
        document.execCommand('copy');
        tempInput.remove();

        toastr.success(window.jsLang('data_link_copied'), window.jsLang('data_success'));
        console.log(link)
    }
})(jQuery);
